/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VWDialogButtons
extends JPanel
implements ActionListener {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int CLOSE = 4;
    public static final int YES = 8;
    public static final int NO = 16;
    public static final int HELP = 32;
    public static final int OKCANCELHELP = 35;
    public static final int YESNOHELP = 56;
    public static final int YESNOCANCELHELP = 58;
    public static final int CLOSEHELP = 36;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_closeButton = null;
    private JButton m_yesButton = null;
    private JButton m_noButton = null;
    private JButton m_helpButton = null;
    private int m_flags = 35;
    private Vector m_listeners = null;

    public VWDialogButtons(int flags) {
        this.m_flags = flags;
        this.m_listeners = new Vector();
        this.initControls();
    }

    public void addDialogButtonsActionListener(IVWDialogButtonsActionListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.addElement(listener);
        }
    }

    public void removeDialogButtonsActionListener(IVWDialogButtonsActionListener listener) {
        if (this.m_listeners != null) {
            this.m_listeners.removeElement(listener);
        }
    }

    public void setButtonEnabled(int nButtonId, boolean bEnable) {
        switch (nButtonId) {
            case 1: {
                if (this.m_okButton == null) break;
                this.m_okButton.setEnabled(bEnable);
                break;
            }
            case 2: {
                if (this.m_cancelButton == null) break;
                this.m_cancelButton.setEnabled(bEnable);
                break;
            }
            case 8: {
                if (this.m_yesButton == null) break;
                this.m_yesButton.setEnabled(bEnable);
                break;
            }
            case 16: {
                if (this.m_noButton == null) break;
                this.m_noButton.setEnabled(bEnable);
                break;
            }
            case 4: {
                if (this.m_closeButton == null) break;
                this.m_closeButton.setEnabled(bEnable);
                break;
            }
            case 32: {
                if (this.m_helpButton == null) break;
                this.m_helpButton.setEnabled(bEnable);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        int nEventId = -1;
        Object src = event.getSource();
        if (src == this.m_okButton) {
            nEventId = 1;
        } else if (src == this.m_cancelButton) {
            nEventId = 2;
        } else if (src == this.m_yesButton) {
            nEventId = 8;
        } else if (src == this.m_noButton) {
            nEventId = 16;
        } else if (src == this.m_closeButton) {
            nEventId = 4;
        } else if (src == this.m_helpButton) {
            nEventId = 32;
        }
        if (nEventId != -1) {
            this.notifyListeners(new VWDialogButtonsActionEvent(this, nEventId));
        }
    }

    private void initControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 10;
        gbCons.fill = 0;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.insets = new Insets(6, 6, 6, 6);
        if ((this.m_flags & 1) == 1) {
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setName("m_okButton_VWDialogButtons");
            this.m_okButton.addActionListener(this);
            this.add((Component)this.m_okButton, gbCons);
        }
        if ((this.m_flags & 4) == 4) {
            ++gbCons.gridx;
            this.m_closeButton = new JButton(VWResource.s_close);
            this.m_closeButton.setName("m_closeButton_VWDialogButtons");
            this.m_closeButton.addActionListener(this);
            this.add((Component)this.m_closeButton, gbCons);
        }
        if ((this.m_flags & 8) == 8) {
            ++gbCons.gridx;
            this.m_yesButton = new JButton(VWResource.s_yes);
            this.m_yesButton.setName("m_yesButton_VWDialogButtons");
            this.m_yesButton.addActionListener(this);
            this.add((Component)this.m_yesButton, gbCons);
        }
        if ((this.m_flags & 0x10) == 16) {
            ++gbCons.gridx;
            this.m_noButton = new JButton(VWResource.s_no);
            this.m_noButton.setName("m_noButton_VWDialogButtons");
            this.m_noButton.addActionListener(this);
            this.add((Component)this.m_noButton, gbCons);
        }
        if ((this.m_flags & 2) == 2) {
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.setName("m_cancelButton_VWDialogButtons");
            this.m_cancelButton.addActionListener(this);
            this.add((Component)this.m_cancelButton, gbCons);
        }
        if ((this.m_flags & 0x20) == 32) {
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.setName("m_helpButton_VWDialogButtons");
            this.m_helpButton.addActionListener(this);
            this.add((Component)this.m_helpButton, gbCons);
        }
    }

    private void notifyListeners(VWDialogButtonsActionEvent event) {
        if (this.m_listeners != null) {
            for (int i = 0; i < this.m_listeners.size(); ++i) {
                IVWDialogButtonsActionListener listener = (IVWDialogButtonsActionListener)this.m_listeners.elementAt(i);
                listener.dialogButtonsActionPerformed(event);
            }
        }
    }
}

